# Constructing dataset for structural estimation

# import packages
import pandas as pd
import numpy as np
import math
import pickle
import os, sys

netw_h=pd.read_csv(r'net_h_small.csv' , header=None)

# creating new student index for students who do the survey and students whom are nominated.
netw=np.array(netw_h)
D=np.zeros(1)
for k in range(1,12):
    D=np.concatenate((D,netw[:,k-1]),axis=0)
D=D[1:D.shape[0]+1]
D1=np.sort(D)
DC=np.unique(D1)
del D1
del D
del k
DC1=np.arange(1,DC.shape[0]+1) 
DC2=np.array([DC,DC1]).T
DT=netw[:,0]
n=DT.shape[0]
m=DC2.shape[0]
Q=np.zeros(n)
Q1=np.zeros(n)
for j in range(1,n+1):
    for v in range(1,m+1):
        if DT[j-1]==DC2[v-1,0]:
            Q[j-1]=DC2[v-1,1]
for j in range(1,Q.shape[0]+1):
    Q1[j-1]=int(Q[j-1])

# construct friendship nomination data based on new student index
FF=netw[:,1:11]
F1=np.zeros((n,10))
for j in range(1,n+1):
    for t in range(1,11):
        if FF[j-1,t-1]>0:
            for v in range(1,m+1):
                if FF[j-1,t-1]==DC2[v-1,0]:
                    F1[j-1,t-1]=DC2[v-1,1]           

# making an adjacency matrix
AF=np.zeros((m,m))
Q2=Q1.astype(int)
for j in range(1,n+1):
    for t in range(1,11):
        if F1[j-1,t-1]>0:
            AF[Q2[j-1]-1,int(F1[j-1,t-1])-1]=AF[Q2[j-1]-1,int(F1[j-1,t-1])-1]+1 # Error was here. Corrected.

A1=(AF>0)*1
Ad1=A1[Q2-1,:] 
Ad=Ad1[:,Q2-1] 
Au=((Ad+Ad.T)>0)*1

# Import social interaction data and construct the social interaction matrix
sdata=pd.read_csv(r'social_interaction_raw_small.csv' , header=None)
sdata=np.array(sdata)
DN=np.zeros(n)
SD1=np.zeros((m,m))
ss=sdata[:,1:51]
for j in range(1,n+1):
    for t in range(1,11):
        if ss[j-1,5*(t-1)]==1 and F1[j-1,t-1]>0:
            SD1[Q2[j-1]-1,int(F1[j-1,t-1])-1]=SD1[Q2[j-1]-1,int(F1[j-1,t-1])-1]+1
        if ss[j-1,5*(t-1)+1]==1 and F1[j-1,t-1]>0:
            SD1[Q2[j-1]-1,int(F1[j-1,t-1])-1]=SD1[Q2[j-1]-1,int(F1[j-1,t-1])-1]+1
        if ss[j-1,5*(t-1)+2]==1 and F1[j-1,t-1]>0:
            SD1[Q2[j-1]-1,int(F1[j-1,t-1])-1]=SD1[Q2[j-1]-1,int(F1[j-1,t-1])-1]+1
        if ss[j-1,5*(t-1)+3]==1 and F1[j-1,t-1]>0:
            SD1[Q2[j-1]-1,int(F1[j-1,t-1])-1]=SD1[Q2[j-1]-1,int(F1[j-1,t-1])-1]+1
        if ss[j-1,5*(t-1)+4]==1 and F1[j-1,t-1]>0:
            SD1[Q2[j-1]-1,int(F1[j-1,t-1])-1]=SD1[Q2[j-1]-1,int(F1[j-1,t-1])-1]+1

SD2=SD1[Q2-1,:]
SD=SD2[:,Q2-1]
SUA=np.maximum(SD,SD.T)

# Constructing data for Table 1
data1=pd.read_csv(r'soc_x_variables.csv' , header=None) # x_sub1
data=np.array(data1)
dat=data[data[:,0].argsort(),]
char=dat[:,0:12]
sch=dat[:,14:15]
gd=dat[:,12:14]
np.savetxt("X_data_sub1.csv", char, delimiter=",")
AS=(SUA>0)*1
Asum=np.sum(AS,axis=1)
sumindex=np.where(Asum>0)
char1=char[sumindex]
np.savetxt("X_data_sub2.csv", char1, delimiter=",")

# Networks with students who have social interaction information
sch1=sch[sumindex]
schlist=np.unique(sch1)
V=schlist.shape[0]
gd1=gd[sumindex]
AS1=AS[sumindex]
AS2=AS1.T[sumindex].T
AS2.shape
SU1=SUA[sumindex]
SU2=SU1.T[sumindex].T
SD2=SD[sumindex]
SD3=SD2.T[sumindex].T
Ad2=Ad[sumindex]
Ad1=Ad2.T[sumindex].T
Au2=Au[sumindex]
Au1=Au2.T[sumindex].T

# Schools of size between 4 and 50
V=schlist.shape[0]
sch_IDlist=[]
Xcell1=[]
Xcell2=[]
Dcell=[]
Scell=[]
SDcell=[]
GE=[]
AUcell=[]
ADcell=[]
for v in range(1,V+1):
    pupil=np.where(sch1==v)[0]
    Ns=pupil.shape[0]
    if Ns>3 and Ns<51:
        sch_IDlist.append(pupil)
        G1=gd1[pupil,:]
        CH1=char1[pupil,:]
        CH=CH1[:,[1,2,3,4,5,6,7,8,9,10,11]]
        Gadj=np.zeros((Ns,Ns))
        Xadj=np.zeros((Ns,Ns,11))
        Xadj2=np.zeros((Ns,Ns,11))
        for nt in range(1,Ns+1):
            for mt in range(1,Ns+1):
                for h in range(1,12):
                    if nt==mt:
                        Xadj[nt-1,mt-1,h-1]=0
                        Xadj2[nt-1,mt-1,h-1]=0
                    else:
                        Xadj[nt-1,mt-1,h-1]=CH[nt-1,h-1]-CH[mt-1,h-1]
                        Xadj2[nt-1,mt-1,h-1]=CH[nt-1,h-1]+CH[mt-1,h-1]
                if nt==mt:
                    Gadj[nt-1,mt-1]=0
                else:
                    Gadj[nt-1,mt-1]=(math.sqrt((G1[nt-1,0]-G1[mt-1,0])**2+(G1[nt-1,1]-G1[mt-1,1])**2))/1000
        Xcell1.append(Xadj)
        Xcell2.append(Xadj2)
        Dcell.append(Gadj)
        SUp1=SU2[pupil,:]
        SUp=SUp1[:,pupil]
        SDp1=SD3[pupil,:]
        SDp=SDp1[:,pupil]
        Scell.append(SUp)
        SDcell.append(SDp)
        AUp1=Au1[pupil,:]
        AUp=AUp1[:,pupil]
        ADp1=Ad1[pupil,:]
        ADp=ADp1[:,pupil]
        AUcell.append(AUp)
        ADcell.append(ADp)
        xa=CH1[:,2:3]
        xag=np.outer(np.ones((Ns,1)),xa)
        GE.append(xag)

# Creating simulation errors
R=100
EPcell=[]
carv=len(sch_IDlist)
for j in range(1,carv+1):
    pupil=sch_IDlist[j-1]
    Ns=pupil.shape[0]
    EP=np.empty([Ns,Ns,R])
    for r in range(1,R+1):
        np.random.seed(j*100+r)
        EP[:,:,r-1]=np.random.standard_normal((Ns,Ns))*(1-np.identity(Ns))
    EPcell.append(EP)
len(sch_IDlist)
Data=[Scell,SDcell,Xcell1,Xcell2,Dcell,EPcell,sch_IDlist,GE,AUcell,ADcell]
with open('spatial_interaction_finaldata_schools4to50.pkl','wb') as f:
    pickle.dump(Data,f)

# Schools of size between 4 and 150
sch_IDlist=[]
Xcell1=[]
Xcell2=[]
Dcell=[]
Scell=[]
SDcell=[]
GE=[]
AUcell=[]
ADcell=[]
BWcell=[]
N_list=np.zeros(V)
char_col=np.zeros([1,12])
for v in range(1,V+1):
    pupil=np.where(sch1==v)[0]
    Ns=pupil.shape[0]
    if Ns>3 and Ns<151:
        sch_IDlist.append(pupil)
        G1=gd1[pupil,:]
        CH1=char1[pupil,:]
        char_col=np.concatenate((char_col,CH1),axis=0) # to construct x variable data for students in 122 schools
        # To create Table 2, construct a matrix of a_ij = 1 if black-white (or vice versa), 2 if black-black, 0 if white-white
        BLK=CH1[:,2]*np.ones((Ns,Ns))
        BW=BLK+(BLK.T)
        BWcell.append(BW)
        CH=CH1[:,[1,2,3,4,5,6,7,8,9,10,11]]
        Gadj=np.zeros((Ns,Ns))
        Xadj=np.zeros((Ns,Ns,11))
        Xadj2=np.zeros((Ns,Ns,11))
        for nt in range(1,Ns+1):
            for mt in range(1,Ns+1):
                for h in range(1,12):
                    if nt==mt:
                        Xadj[nt-1,mt-1,h-1]=0
                        Xadj2[nt-1,mt-1,h-1]=0
                    else:
                        Xadj[nt-1,mt-1,h-1]=CH[nt-1,h-1]-CH[mt-1,h-1]
                        Xadj2[nt-1,mt-1,h-1]=CH[nt-1,h-1]+CH[mt-1,h-1]
                if nt==mt:
                    Gadj[nt-1,mt-1]=0
                else:
                    Gadj[nt-1,mt-1]=(math.sqrt((G1[nt-1,0]-G1[mt-1,0])**2+(G1[nt-1,1]-G1[mt-1,1])**2))/1000
        Xcell1.append(Xadj)
        Xcell2.append(Xadj2)
        Dcell.append(Gadj)
        SUp1=SU2[pupil,:]
        SUp=SUp1[:,pupil]
        SDp1=SD3[pupil,:]
        SDp=SDp1[:,pupil]
        Scell.append(SUp)
        SDcell.append(SDp)
        AUp1=Au1[pupil,:]
        AUp=AUp1[:,pupil]
        ADp1=Ad1[pupil,:]
        ADp=ADp1[:,pupil]
        AUcell.append(AUp)
        ADcell.append(ADp)
        xa=CH1[:,2:3]
        xag=np.outer(np.ones((Ns,1)),xa)
        GE.append(xag)

# Creating simulation errors
R=100
EPcell=[]
carv=len(sch_IDlist)
for j in range(1,carv+1):
    pupil=sch_IDlist[j-1]
    Ns=pupil.shape[0]
    EP=np.empty([Ns,Ns,R])
    for r in range(1,R+1):
        np.random.seed(j*100+r)
        EP[:,:,r-1]=np.random.standard_normal((Ns,Ns))*(1-np.identity(Ns))
    EPcell.append(EP)
len(sch_IDlist)
Data=[Scell,SDcell,Xcell1,Xcell2,Dcell,EPcell,sch_IDlist,GE,AUcell,ADcell,N_list]
with open('spatial_interaction_finaldata_schools4to150.pkl','wb') as f:
    pickle.dump(Data,f)
with open('BWcell_schools4to150.pkl','wb') as f:
    pickle.dump(BWcell,f)

char_col1=char_col[1:char_col.shape[0]+1,:]
np.savetxt("X_data_sub3.csv", char_col1, delimiter=",")
